VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBNLSHandler"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Index       As Integer
Private Winsock     As Winsock

'Events:
Public Event SendAuthInfo(ByVal Index As Integer)
Public Event SendAuthCheck(ByVal Index As Integer)

'Output methods
Public Event OutputPacketRecieved(ByVal Index As Integer, ByVal PacketID As String)
Public Event OutputPacketSent(ByVal Index As Integer, ByVal PacketID As String)


Public Function setClassVars(ByVal myIndex As Integer, ByRef myWinsock As Winsock)
    Index = myIndex
    Set Winsock = myWinsock
End Function

Public Function handleBNLSPACKETSRAW(ByVal Data As String)
Dim pktConstant As Byte

    With PktBuffer
        .SetData Data
        .GetWORD
        pktConstant = .GetByte
    End With
    
    'Debug.Print DebugOutput(Data)
    
    Select Case pktConstant
    
        Case BNLS_REQUESTVERSIONBYTE
            RaiseEvent OutputPacketRecieved(Index, "BNLS_REQUESTVERSIONBYTE")
            Call handleBNLS_REQUESTVERSIONBYTE
            
        Case BNLS_CHOOSENLSREVISION
            RaiseEvent OutputPacketRecieved(Index, "BNLS_CHOOSENLSVERSION")
            Call handleBNLS_CHOOSENLSREVISION
            
        Case BNLS_VERSIONCHECK
            RaiseEvent OutputPacketRecieved(Index, "BNLS_VERSIONCHECK")
            Call handleBNLS_VERSIONCHECK
            
    End Select
End Function


'BNLS Incoming Packet Handling Functions: (These should, under all circumstances, be private)
Private Function handleBNLS_VERSIONCHECK()
    With PktBuffer
        Select Case .GetBoolean
            Case True
                BNETDATA(Index).lngVersion = .GetDWORD
                BNETDATA(Index).lngCheckSum = .GetDWORD
                BNETDATA(Index).strEXEInfo = .GetString
                'BNCSHandler.sendSID_AUTH_CHECK
                RaiseEvent SendAuthCheck(Index)
            Case False
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNLS & "Version check failed"
                closeBot (Index)
        End Select
    End With
End Function

Private Function handleBNLS_CHOOSENLSREVISION()
    Select Case PktBuffer.GetBoolean
        Case True
        Case False
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNLS & "NLS revision number was not recognized"
            closeBot (Index)
    End Select
End Function

Private Function handleBNLS_REQUESTVERSIONBYTE()
    With PktBuffer
        If .GetDWORD <> &H0 Then
            Bots(Index).VerByte = .GetDWORD
            'BNCSHandler.sendSID_AUTH_INFO
            RaiseEvent SendAuthInfo(Index)
        Else
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNLS & "Invalid version byte received"
        End If
    End With
End Function

'BNLS Outgoing Packet Functions:

Public Function sendBNLS_REQUESTVERSIONBYTE()
    With PktBuffer
        .Reset
        .InsertDWORD Bots(Index).Client
        
        .Send Winsock, BNLS_REQUESTVERSIONBYTE, pBNLS
    End With
    RaiseEvent OutputPacketSent(Index, "BNLS_REQUESTVERSIONBYTE")
End Function

Public Function sendBNLS_CHOOSENLSREVISION()
    With PktBuffer
        .Reset
        .InsertDWORD BNETDATA(Index).lngLogonType
        
        .Send Winsock, BNLS_CHOOSENLSREVISION, pBNLS
    End With
    RaiseEvent OutputPacketSent(Index, "BNLS_CHOOSENLSREVISION")
End Function

Public Function sendBNLS_VERSIONCHECK()
    BNETDATA(Index).lngMPQNumber = extractMPQNumber(BNETDATA(Index).strMPQName)
    
    With PktBuffer
        .Reset
        .InsertDWORD Bots(Index).Client
        .InsertDWORD BNETDATA(Index).lngMPQNumber
        .InsertNTString BNETDATA(Index).strValueString
        
        .Send Winsock, BNLS_VERSIONCHECK, pBNLS
    End With
    RaiseEvent OutputPacketSent(Index, "BNLS_VERSIONCHECK")
End Function
